IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP_DELETE_PROCESSAMENTO_PENDENTE]'))
	DROP TRIGGER [dbo].[TRG_EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP_DELETE_PROCESSAMENTO_PENDENTE]
GO
 
CREATE TRIGGER [dbo].[TRG_EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP_DELETE_PROCESSAMENTO_PENDENTE] ON [dbo].[EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP] 
FOR DELETE
AS
UPDATE
	p
SET 
	p.DT_PROC=imp.DT_CAD,
	p.DT_CAD=GETDATE()
FROM
	EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p INNER JOIN EST_PROD_IMP imp ON
	p.CD_EMP = imp.CD_EMP AND
	p.CD_FILIAL = imp.CD_FILIAL AND
	p.CD_PROD = imp.CD_PROD
	INNER JOIN DELETED d ON   
	imp.CD_EMP = d.CD_EMP AND   
	imp.CD_FILIAL = d.CD_FILIAL_DEST AND   
	imp.CD_IMP = d.CD_IMP AND   
	imp.CD_PROD = d.CD_PROD  
WHERE
	p.DT_PROC > imp.DT_CAD;

INSERT INTO EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE
	(CD_EMP,
	CD_FILIAL,
	CD_PROD,
	DT_PROC,
	DT_CAD,
	DT_PROC_ATUAL)
SELECT DISTINCT 
	d.CD_EMP,
	d.CD_FILIAL_DEST,
	d.CD_PROD,
	MIN(imp.DT_CAD),
	GETDATE(),
	NULL
FROM
	EST_PROD_IMP imp INNER JOIN DELETED d ON   
	imp.CD_EMP = d.CD_EMP AND   
	imp.CD_FILIAL = d.CD_FILIAL_DEST AND   
	imp.CD_IMP = d.CD_IMP AND   
	imp.CD_PROD = d.CD_PROD  
	LEFT OUTER JOIN EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p ON
	p.CD_EMP = imp.CD_EMP AND
	p.CD_FILIAL = imp.CD_FILIAL AND
	p.CD_PROD = imp.CD_PROD
WHERE
	p.CD_PROD IS NULL
GROUP BY
	d.CD_EMP,
	d.CD_FILIAL_DEST,
	d.CD_PROD;



--Deletando ultimo processamento de custo medio
DELETE
	p
FROM
	EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO p INNER JOIN DELETED d ON
	p.CD_EMP = d.CD_EMP AND
	p.CD_FILIAL = d.CD_FILIAL_DEST AND
	p.CD_PROD = d.CD_PROD;

GO


